"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.defineSystemRoutes = defineSystemRoutes;
exports.licenseHandler = licenseHandler;
exports.systemInfoHandler = systemInfoHandler;
var _constants = require("../../../utils/constants");
var _configSchema = require("@kbn/config-schema");
/*
 *    Copyright 2020 floragunn GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

function systemInfoHandler({
  searchGuardBackend,
  logger
}) {
  return async function (context, request, response) {
    try {
      const body = await searchGuardBackend.systeminfo(request.headers);

      // Avoid Cacheable SSL Page
      // https://floragunn.atlassian.net/browse/ITT-2388
      return response.ok({
        body,
        headers: {
          'Cache-Control': 'no-cache, no-store'
        }
      });
    } catch (error) {
      logger.error(`systemInfoHandler: ${error.stack}`);
      return response.internalError({
        body: error
      });
    }
  };
}
function licenseHandler({
  searchGuardBackend,
  logger
}) {
  return async function (context, request, response) {
    try {
      const body = await searchGuardBackend.uploadLicense(request.headers, request.body);
      return response.ok({
        body
      });
    } catch (error) {
      logger.error(`licenseHandler: ${error.stack}`);
      return response.internalError({
        body: error
      });
    }
  };
}
function defineSystemRoutes({
  searchGuardBackend,
  logger,
  kibanaCore
}) {
  const router = kibanaCore.http.createRouter();
  router.get({
    path: `${_constants.API_ROOT}/systeminfo`,
    validate: false,
    options: {
      authRequired: false
    }
  }, systemInfoHandler({
    searchGuardBackend,
    logger
  }));
  router.post({
    path: `${_constants.API_ROOT}/license`,
    validate: {
      body: _configSchema.schema.object({
        sg_license: _configSchema.schema.string()
      })
    },
    options: {
      authRequired: true
    }
  }, licenseHandler({
    searchGuardBackend,
    logger
  }));
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJfY29uc3RhbnRzIiwicmVxdWlyZSIsIl9jb25maWdTY2hlbWEiLCJzeXN0ZW1JbmZvSGFuZGxlciIsInNlYXJjaEd1YXJkQmFja2VuZCIsImxvZ2dlciIsImNvbnRleHQiLCJyZXF1ZXN0IiwicmVzcG9uc2UiLCJib2R5Iiwic3lzdGVtaW5mbyIsImhlYWRlcnMiLCJvayIsImVycm9yIiwic3RhY2siLCJpbnRlcm5hbEVycm9yIiwibGljZW5zZUhhbmRsZXIiLCJ1cGxvYWRMaWNlbnNlIiwiZGVmaW5lU3lzdGVtUm91dGVzIiwia2liYW5hQ29yZSIsInJvdXRlciIsImh0dHAiLCJjcmVhdGVSb3V0ZXIiLCJnZXQiLCJwYXRoIiwiQVBJX1JPT1QiLCJ2YWxpZGF0ZSIsIm9wdGlvbnMiLCJhdXRoUmVxdWlyZWQiLCJwb3N0Iiwic2NoZW1hIiwib2JqZWN0Iiwic2dfbGljZW5zZSIsInN0cmluZyJdLCJzb3VyY2VzIjpbInJvdXRlcy5qcyJdLCJzb3VyY2VzQ29udGVudCI6WyIvKlxuICogICAgQ29weXJpZ2h0IDIwMjAgZmxvcmFndW5uIEdtYkhcbiAqXG4gKiBMaWNlbnNlZCB1bmRlciB0aGUgQXBhY2hlIExpY2Vuc2UsIFZlcnNpb24gMi4wICh0aGUgXCJMaWNlbnNlXCIpO1xuICogeW91IG1heSBub3QgdXNlIHRoaXMgZmlsZSBleGNlcHQgaW4gY29tcGxpYW5jZSB3aXRoIHRoZSBMaWNlbnNlLlxuICogWW91IG1heSBvYnRhaW4gYSBjb3B5IG9mIHRoZSBMaWNlbnNlIGF0XG4gKlxuICogaHR0cDovL3d3dy5hcGFjaGUub3JnL2xpY2Vuc2VzL0xJQ0VOU0UtMi4wXG4gKlxuICogVW5sZXNzIHJlcXVpcmVkIGJ5IGFwcGxpY2FibGUgbGF3IG9yIGFncmVlZCB0byBpbiB3cml0aW5nLCBzb2Z0d2FyZVxuICogZGlzdHJpYnV0ZWQgdW5kZXIgdGhlIExpY2Vuc2UgaXMgZGlzdHJpYnV0ZWQgb24gYW4gXCJBUyBJU1wiIEJBU0lTLFxuICogV0lUSE9VVCBXQVJSQU5USUVTIE9SIENPTkRJVElPTlMgT0YgQU5ZIEtJTkQsIGVpdGhlciBleHByZXNzIG9yIGltcGxpZWQuXG4gKiBTZWUgdGhlIExpY2Vuc2UgZm9yIHRoZSBzcGVjaWZpYyBsYW5ndWFnZSBnb3Zlcm5pbmcgcGVybWlzc2lvbnMgYW5kXG4gKiBsaW1pdGF0aW9ucyB1bmRlciB0aGUgTGljZW5zZS5cbiAqL1xuXG5pbXBvcnQgeyBBUElfUk9PVCB9IGZyb20gJy4uLy4uLy4uL3V0aWxzL2NvbnN0YW50cyc7XG5pbXBvcnQgeyBzY2hlbWEgfSBmcm9tICdAa2JuL2NvbmZpZy1zY2hlbWEnO1xuXG5leHBvcnQgZnVuY3Rpb24gc3lzdGVtSW5mb0hhbmRsZXIoeyBzZWFyY2hHdWFyZEJhY2tlbmQsIGxvZ2dlciB9KSB7XG4gIHJldHVybiBhc3luYyBmdW5jdGlvbiAoY29udGV4dCwgcmVxdWVzdCwgcmVzcG9uc2UpIHtcbiAgICB0cnkge1xuICAgICAgY29uc3QgYm9keSA9IGF3YWl0IHNlYXJjaEd1YXJkQmFja2VuZC5zeXN0ZW1pbmZvKHJlcXVlc3QuaGVhZGVycyk7XG5cbiAgICAgIC8vIEF2b2lkIENhY2hlYWJsZSBTU0wgUGFnZVxuICAgICAgLy8gaHR0cHM6Ly9mbG9yYWd1bm4uYXRsYXNzaWFuLm5ldC9icm93c2UvSVRULTIzODhcbiAgICAgIHJldHVybiByZXNwb25zZS5vayh7XG4gICAgICAgIGJvZHksXG4gICAgICAgIGhlYWRlcnM6IHsgJ0NhY2hlLUNvbnRyb2wnOiAnbm8tY2FjaGUsIG5vLXN0b3JlJyB9LFxuICAgICAgfSk7XG4gICAgfSBjYXRjaCAoZXJyb3IpIHtcbiAgICAgIGxvZ2dlci5lcnJvcihgc3lzdGVtSW5mb0hhbmRsZXI6ICR7ZXJyb3Iuc3RhY2t9YCk7XG4gICAgICByZXR1cm4gcmVzcG9uc2UuaW50ZXJuYWxFcnJvcih7IGJvZHk6IGVycm9yIH0pO1xuICAgIH1cbiAgfTtcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIGxpY2Vuc2VIYW5kbGVyKHsgc2VhcmNoR3VhcmRCYWNrZW5kLCBsb2dnZXIgfSkge1xuICByZXR1cm4gYXN5bmMgZnVuY3Rpb24gKGNvbnRleHQsIHJlcXVlc3QsIHJlc3BvbnNlKSB7XG4gICAgdHJ5IHtcbiAgICAgIGNvbnN0IGJvZHkgPSBhd2FpdCBzZWFyY2hHdWFyZEJhY2tlbmQudXBsb2FkTGljZW5zZShyZXF1ZXN0LmhlYWRlcnMsIHJlcXVlc3QuYm9keSk7XG5cbiAgICAgIHJldHVybiByZXNwb25zZS5vayh7IGJvZHkgfSk7XG4gICAgfSBjYXRjaCAoZXJyb3IpIHtcbiAgICAgIGxvZ2dlci5lcnJvcihgbGljZW5zZUhhbmRsZXI6ICR7ZXJyb3Iuc3RhY2t9YCk7XG4gICAgICByZXR1cm4gcmVzcG9uc2UuaW50ZXJuYWxFcnJvcih7IGJvZHk6IGVycm9yIH0pO1xuICAgIH1cbiAgfTtcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIGRlZmluZVN5c3RlbVJvdXRlcyh7IHNlYXJjaEd1YXJkQmFja2VuZCwgbG9nZ2VyLCBraWJhbmFDb3JlIH0pIHtcbiAgY29uc3Qgcm91dGVyID0ga2liYW5hQ29yZS5odHRwLmNyZWF0ZVJvdXRlcigpO1xuXG4gIHJvdXRlci5nZXQoXG4gICAge1xuICAgICAgcGF0aDogYCR7QVBJX1JPT1R9L3N5c3RlbWluZm9gLFxuICAgICAgdmFsaWRhdGU6IGZhbHNlLFxuICAgICAgb3B0aW9uczoge1xuICAgICAgICBhdXRoUmVxdWlyZWQ6IGZhbHNlLFxuICAgICAgfSxcbiAgICB9LFxuICAgIHN5c3RlbUluZm9IYW5kbGVyKHsgc2VhcmNoR3VhcmRCYWNrZW5kLCBsb2dnZXIgfSlcbiAgKTtcblxuICByb3V0ZXIucG9zdChcbiAgICB7XG4gICAgICBwYXRoOiBgJHtBUElfUk9PVH0vbGljZW5zZWAsXG4gICAgICB2YWxpZGF0ZToge1xuICAgICAgICBib2R5OiBzY2hlbWEub2JqZWN0KHtcbiAgICAgICAgICBzZ19saWNlbnNlOiBzY2hlbWEuc3RyaW5nKCksXG4gICAgICAgIH0pLFxuICAgICAgfSxcbiAgICAgIG9wdGlvbnM6IHtcbiAgICAgICAgYXV0aFJlcXVpcmVkOiB0cnVlLFxuICAgICAgfSxcbiAgICB9LFxuICAgIGxpY2Vuc2VIYW5kbGVyKHsgc2VhcmNoR3VhcmRCYWNrZW5kLCBsb2dnZXIgfSlcbiAgKTtcbn1cbiJdLCJtYXBwaW5ncyI6Ijs7Ozs7Ozs7QUFnQkEsSUFBQUEsVUFBQSxHQUFBQyxPQUFBO0FBQ0EsSUFBQUMsYUFBQSxHQUFBRCxPQUFBO0FBakJBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7QUFLTyxTQUFTRSxpQkFBaUJBLENBQUM7RUFBRUMsa0JBQWtCO0VBQUVDO0FBQU8sQ0FBQyxFQUFFO0VBQ2hFLE9BQU8sZ0JBQWdCQyxPQUFPLEVBQUVDLE9BQU8sRUFBRUMsUUFBUSxFQUFFO0lBQ2pELElBQUk7TUFDRixNQUFNQyxJQUFJLEdBQUcsTUFBTUwsa0JBQWtCLENBQUNNLFVBQVUsQ0FBQ0gsT0FBTyxDQUFDSSxPQUFPLENBQUM7O01BRWpFO01BQ0E7TUFDQSxPQUFPSCxRQUFRLENBQUNJLEVBQUUsQ0FBQztRQUNqQkgsSUFBSTtRQUNKRSxPQUFPLEVBQUU7VUFBRSxlQUFlLEVBQUU7UUFBcUI7TUFDbkQsQ0FBQyxDQUFDO0lBQ0osQ0FBQyxDQUFDLE9BQU9FLEtBQUssRUFBRTtNQUNkUixNQUFNLENBQUNRLEtBQUssQ0FBRSxzQkFBcUJBLEtBQUssQ0FBQ0MsS0FBTSxFQUFDLENBQUM7TUFDakQsT0FBT04sUUFBUSxDQUFDTyxhQUFhLENBQUM7UUFBRU4sSUFBSSxFQUFFSTtNQUFNLENBQUMsQ0FBQztJQUNoRDtFQUNGLENBQUM7QUFDSDtBQUVPLFNBQVNHLGNBQWNBLENBQUM7RUFBRVosa0JBQWtCO0VBQUVDO0FBQU8sQ0FBQyxFQUFFO0VBQzdELE9BQU8sZ0JBQWdCQyxPQUFPLEVBQUVDLE9BQU8sRUFBRUMsUUFBUSxFQUFFO0lBQ2pELElBQUk7TUFDRixNQUFNQyxJQUFJLEdBQUcsTUFBTUwsa0JBQWtCLENBQUNhLGFBQWEsQ0FBQ1YsT0FBTyxDQUFDSSxPQUFPLEVBQUVKLE9BQU8sQ0FBQ0UsSUFBSSxDQUFDO01BRWxGLE9BQU9ELFFBQVEsQ0FBQ0ksRUFBRSxDQUFDO1FBQUVIO01BQUssQ0FBQyxDQUFDO0lBQzlCLENBQUMsQ0FBQyxPQUFPSSxLQUFLLEVBQUU7TUFDZFIsTUFBTSxDQUFDUSxLQUFLLENBQUUsbUJBQWtCQSxLQUFLLENBQUNDLEtBQU0sRUFBQyxDQUFDO01BQzlDLE9BQU9OLFFBQVEsQ0FBQ08sYUFBYSxDQUFDO1FBQUVOLElBQUksRUFBRUk7TUFBTSxDQUFDLENBQUM7SUFDaEQ7RUFDRixDQUFDO0FBQ0g7QUFFTyxTQUFTSyxrQkFBa0JBLENBQUM7RUFBRWQsa0JBQWtCO0VBQUVDLE1BQU07RUFBRWM7QUFBVyxDQUFDLEVBQUU7RUFDN0UsTUFBTUMsTUFBTSxHQUFHRCxVQUFVLENBQUNFLElBQUksQ0FBQ0MsWUFBWSxFQUFFO0VBRTdDRixNQUFNLENBQUNHLEdBQUcsQ0FDUjtJQUNFQyxJQUFJLEVBQUcsR0FBRUMsbUJBQVMsYUFBWTtJQUM5QkMsUUFBUSxFQUFFLEtBQUs7SUFDZkMsT0FBTyxFQUFFO01BQ1BDLFlBQVksRUFBRTtJQUNoQjtFQUNGLENBQUMsRUFDRHpCLGlCQUFpQixDQUFDO0lBQUVDLGtCQUFrQjtJQUFFQztFQUFPLENBQUMsQ0FBQyxDQUNsRDtFQUVEZSxNQUFNLENBQUNTLElBQUksQ0FDVDtJQUNFTCxJQUFJLEVBQUcsR0FBRUMsbUJBQVMsVUFBUztJQUMzQkMsUUFBUSxFQUFFO01BQ1JqQixJQUFJLEVBQUVxQixvQkFBTSxDQUFDQyxNQUFNLENBQUM7UUFDbEJDLFVBQVUsRUFBRUYsb0JBQU0sQ0FBQ0csTUFBTTtNQUMzQixDQUFDO0lBQ0gsQ0FBQztJQUNETixPQUFPLEVBQUU7TUFDUEMsWUFBWSxFQUFFO0lBQ2hCO0VBQ0YsQ0FBQyxFQUNEWixjQUFjLENBQUM7SUFBRVosa0JBQWtCO0lBQUVDO0VBQU8sQ0FBQyxDQUFDLENBQy9DO0FBQ0gifQ==